//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.IO;
using WeifenLuo.WinFormsUI;

namespace SID_monitor
{
    public partial class ViewReportParametersDockablePanel : DockContent
    {
        public ViewReportParametersDockablePanel()
        {
            InitializeComponent();

            this.labelDatabaseFilename.Text = String.Empty;
            this.labelGOESdatabaseFilename.Text = String.Empty;

            this.checkBoxShowSun.Enabled = false;
            this.checkBoxShowForecast.Enabled = false;
            this.checkBoxShowGOES10.Enabled = false;
            this.checkBoxShowGOES11.Enabled = false;
            this.checkBoxShowGOES12.Enabled = false;


        }

        #region Properties
        public string ReportFilename
        {
            get
            {
                return this.textBoxReportFilename.Text;
            }
            set
            {
                this.textBoxReportFilename.Text = value;
            }
        }

        public bool ShowSunChecked
        {
            get
            {
                return this.checkBoxShowSun.Checked;

            }
            set
            {
                this.checkBoxShowSun.Checked = value;
            }
        }

        public bool ShowSunEnabled
        {
            get
            {
                return this.checkBoxShowSun.Enabled;

            }
            set
            {
                this.checkBoxShowSun.Enabled = value;
            }
        }

        public bool ShowForecastChecked
        {
            get
            {
                return this.checkBoxShowForecast.Checked;

            }
            set
            {
                this.checkBoxShowForecast.Checked = value;
            }
        }

        public bool ShowForecastEnabled
        {
            get
            {
                return this.checkBoxShowForecast.Enabled;

            }
            set
            {
                this.checkBoxShowForecast.Enabled = value;
            }
        }

        public bool ShowGOES10Checked
        {
            get
            {
                return this.checkBoxShowGOES10.Checked;
            }
            set
            {
                this.checkBoxShowGOES10.Checked = value;
            }
        }

        public bool ShowGOES11Checked
        {
            get
            {
                return this.checkBoxShowGOES11.Checked;
            }
            set
            {
                this.checkBoxShowGOES11.Checked = value;
            }
        }

        public bool ShowGOES12Checked
        {
            get
            {
                return this.checkBoxShowGOES12.Checked;
            }
            set
            {
                this.checkBoxShowGOES12.Checked = value;
            }
        }

        public bool ShowGOES10Enabled
        {
            get
            {
                return this.checkBoxShowGOES10.Enabled;
            }
            set
            {
                this.checkBoxShowGOES10.Enabled = value;
            }
        }

        public bool ShowGOES11Enabled
        {
            get
            {
                return this.checkBoxShowGOES11.Enabled;
            }
            set
            {
                this.checkBoxShowGOES11.Enabled = value;
            }
        }

        public bool ShowGOES12Enabled
        {
            get
            {
                return this.checkBoxShowGOES12.Enabled;
            }
            set
            {
                this.checkBoxShowGOES12.Enabled = value;
            }
        }

        public string LabelChannelsDatabaseFilename
        {
            get
            {
                return this.labelDatabaseFilename.Text;
            }
            set
            {
                this.labelDatabaseFilename.Text = value;
            }
        }

        public string LabelGOESDatabaseFilename
        {
            get
            {
                return this.labelGOESdatabaseFilename.Text;
            }
            set
            {
                this.labelGOESdatabaseFilename.Text = value;
            }
        }

        #endregion

        #region LoadReportButton Method
        public void buttonLoadReport_Click(object sender, EventArgs e)
        {
            this.openFileDialog.DefaultExt = "dat";
            this.openFileDialog.Filter = "Report Files|*.dat|All files|*.*";
            this.openFileDialog.Title = "Select Report File";

            if (File.Exists(this.textBoxReportFilename.Text))
            {
                this.openFileDialog.FileName = this.textBoxReportFilename.Text;
            }

            if (this.openFileDialog.ShowDialog() == DialogResult.OK)
            {
                this.textBoxReportFilename.Text = this.openFileDialog.FileName;
            }
        }
        #endregion

        #region Checkboxes methods
        /// <summary>
        /// Ask to update the graph when "Show GOES10" selection changes
        /// </summary>
        private void checkBoxShowGOES10_CheckedChanged(object sender, EventArgs e)
        {
            OnGraphUpdateRequested(e);
        }

        /// <summary>
        /// Ask to update the graph when "Show GOES11" selection changes
        /// </summary>
        private void checkBoxShowGOES11_CheckedChanged(object sender, EventArgs e)
        {
            OnGraphUpdateRequested(e);
        }

        /// <summary>
        /// Ask to update the graph when "Show GOES12" selection changes
        /// </summary>
        private void checkBoxShowGOES12_CheckedChanged(object sender, EventArgs e)
        {
            OnGraphUpdateRequested(e);
        }

        /// <summary>
        /// Ask to update the graph when "Show Sun" selection changes
        /// </summary>
        private void checkBoxShowSun_CheckedChanged(object sender, EventArgs e)
        {
            OnGraphUpdateRequested(e);
        }


        /// <summary>
        /// Ask to update the graph when "Show Forest" selection changes
        /// </summary>
        private void checkBoxShowForecast_CheckedChanged(object sender, EventArgs e)
        {
            OnGraphUpdateRequested(e);
        }
        #endregion

        #region TextBoxReportFilename method
        private void textBoxReportFilename_TextChanged(object sender, EventArgs e)
        {
            TextBox currentTextBox = (TextBox)sender;
            if (!File.Exists(currentTextBox.Text) && currentTextBox.Enabled)
            {
                errorProvider.SetError(currentTextBox, "This file does not exists");
                OnReportFileError(e);
            }
            else
            {
                errorProvider.SetError(currentTextBox, "");
                OnLoadReportRequested(e);
            }
        }
        #endregion

        #region Events
        /// <summary>
        /// GraphUpdateRequested Event
        /// </summary>

        public event EventHandler GraphUpdateRequested;  // GraphUpdate is requested

        protected virtual void OnGraphUpdateRequested(EventArgs e)
        {
            EventHandler handler = GraphUpdateRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        /// <summary>
        /// LoadReportRequested Event
        /// </summary>

        public event EventHandler LoadReportRequested;  // Load Report is requested

        protected virtual void OnLoadReportRequested(EventArgs e)
        {
            EventHandler handler = LoadReportRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        /// <summary>
        /// ReportFileError Event
        /// </summary>

        public event EventHandler ReportFileError;  // Report File is in error

        protected virtual void OnReportFileError(EventArgs e)
        {
            EventHandler handler = ReportFileError;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }
#endregion

    }
}
